/* 
 * defs.h
 * Copyright (C) 2002, AVM GmbH. All rights reserved.
 * 
 * This Software is  free software. You can redistribute and/or
 * modify such free software under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * The free software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this Software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA, or see
 * http://www.opensource.org/licenses/lgpl-license.html
 * 
 * Contact: AVM GmbH, Alt-Moabit 95, 10559 Berlin, Germany, email: info@avm.de
 */

#ifndef __have_defs_h__
#define __have_defs_h__

#ifndef LINUX_VERSION_CODE
# include <linux/version.h>
#endif

#ifndef TRUE
# define TRUE		(1==1)
# define FALSE		(1==0)
#endif

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#if defined (__fcdslslusb__)
# define USB_PRODUCT_ID_FCDSLSLUSB	0x3500
# define PRODUCT_LOGO			"AVM FRITZ!Card DSL SL USB"
# define INTERFACE			"usb"
#else
# error Card specifier missing!
#endif

#define	VENDOR_ID_AVM			0x057C
#define DRIVER_LOGO			PRODUCT_LOGO " driver"
#define SHORT_LOGO			TARGET "-" INTERFACE

#define	REV_DEFAULT			"0.1"

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#if defined (OSDEBUG) && defined (NDEBUG)
# undef NDEBUG
#endif

/*---------------------------------------------------------------------------*\
 * LOG_MESSAGES - CAPI trace
 * LOG_ALLOC - Log heap activity
 * LOG_LINK - Log buffer transfers
\*---------------------------------------------------------------------------*/

#define	UNUSED_ARG(x)	(x)=(x)

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 3, 13)
# define GET_PCI_BASE(d, r)	(d)->base_address[r]
#else
# define GET_PCI_BASE(d, r)	(d)->resource[r].start
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 3, 43)
# define KFREE_SKB(x)	dev_kfree_skb(x)
#else
# include <linux/netdevice.h>
# define KFREE_SKB(x)	dev_kfree_skb_any(x)
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 5, 0)
typedef void irqreturn_t;

#define IRQ_NONE
#define IRQ_HANDLED
#define IRQ_RETVAL(x)
#endif

#endif

