/* 
 * main.c
 * Copyright (C) 2002, AVM GmbH. All rights reserved.
 * 
 * This Software is  free software. You can redistribute and/or
 * modify such free software under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * The free software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this Software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA, or see
 * http://www.opensource.org/licenses/lgpl-license.html
 * 
 * Contact: AVM GmbH, Alt-Moabit 95, 10559 Berlin, Germany, email: info@avm.de
 */

#ifndef EXPORT_SYMTAB
# define EXPORT_SYMTAB
#endif

#include <stdarg.h>
#include <asm/uaccess.h>
#include <linux/pci.h>
#include <linux/config.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/string.h>
#include <linux/skbuff.h>
#include <linux/errno.h>
#include <linux/capi.h>
#include <linux/ctype.h>
#include "capilli.h"
#include "driver.h" 
#include "tools.h"
#include "defs.h"

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
static char *	REVCONST = "$Revision: $";
char		REVISION[32];

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)

static struct pci_device_id fcdslsl_id_table[] __initdata = {

	{ PCI_VENDOR_ID_AVM, PCI_DEVICE_ID_FCDSL2,
		PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0 },
        { /* Terminating entry */ }
} ;

MODULE_DEVICE_TABLE (pci, fcdslsl_id_table);
#else
#define	__exit
#endif

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
short int	VCC = 0x01;
short int	VPI = 0x01;
short int	VCI = 0x20;

MODULE_PARM (VCC, "h");
MODULE_PARM (VPI, "h");
MODULE_PARM (VCI, "h");

MODULE_PARM_DESC (VCC, "VCC - Virtual Channel Connection");
MODULE_PARM_DESC (VPI, "VPI - Virtual Path Identifier");
MODULE_PARM_DESC (VCI, "VCI - Virtual Channel Identifier");

#if defined (MODULE_LICENSE)
MODULE_LICENSE ("Proprietary");
#endif
#if defined (MODULE_DESCRIPTION)
MODULE_DESCRIPTION ("CAPI4Linux: Driver for " PRODUCT_LOGO);
#endif

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#ifndef NDEBUG
static void base_address (void) {

	log ("Base address: %p\n", base_address);
	log ("Compile time: %s\n", __TIME__);
} /* base_address */
#endif

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
static int __init auto_attach (void) {

	lprintf (KERN_INFO, "Auto-attaching...\n");
	return add_card (&capi_interface, NULL);
} /* auto_attach */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
void inc_use_count (void) { MOD_INC_USE_COUNT; }
void dec_use_count (void) { MOD_DEC_USE_COUNT; }

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
static int __init fcdsl_init (void) {
	char * tmp;
	
#define	RETURN(x)	MOD_DEC_USE_COUNT; return (x);

	EXPORT_NO_SYMBOLS;
#ifndef NDEBUG
	base_address ();
#endif
	if ((NULL != (tmp = strchr (REVCONST, ':'))) && isdigit (*(tmp + 2))) {
		strncpy (REVISION, tmp + 1, sizeof (REVISION));
		tmp = strchr (REVISION, '$');
		*tmp = 0;
	} else {
		strcpy (REVISION, REV_DEFAULT);
	}
	lprintf (KERN_INFO, "%s, revision %s\n", DRIVER_LOGO, REVISION);
        lprintf (KERN_INFO, "(%s built on %s at %s)\n", TARGET, __DATE__, __TIME__);

	/*-------------------------------------------------------------------*\
	 * 64 bit CAPI is not supported yet.
	\*-------------------------------------------------------------------*/
	if (sizeof (char *) > 4) {
		lprintf (KERN_ERR, "Cannot deal with 64 bit CAPI messages!\n");
		return -ENOSYS;
	}

	MOD_INC_USE_COUNT;		/* Protect attachment procedure */
	lprintf (KERN_INFO, "Loading...\n");
	if (!driver_init ()) {
		lprintf (KERN_INFO, "Error: Driver library not available.\n");
		lprintf (KERN_INFO, "Not loaded.\n");
		RETURN (-ENOSYS);
	}
	capi_driver = attach_capi_driver (&capi_interface);
	if (NULL == capi_driver) {
		lprintf (KERN_INFO, "Error: Could not attach the driver.\n");
		lprintf (KERN_INFO, "Not loaded.\n");
		driver_exit ();
		RETURN (-EIO);
	} 
	if (0 != auto_attach ()) {
		lprintf (KERN_INFO, "Not loaded.\n");
		detach_capi_driver (&capi_interface);
		driver_exit ();
		RETURN (-EIO);
	}
	lprintf (KERN_INFO, "Loaded.\n");
	RETURN (0);

#undef RETURN

} /* fcdsl_init */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
static void __exit fcdsl_exit (void) {

#if defined (__fcdsl__)
	if (capi_controller[0] != NULL) {
		lprintf (KERN_INFO, "Shutting down controller 0...\n");
		(*capi_driver->detach_ctr) (capi_controller[0]);
	}
#endif
	if (capi_controller[1] != NULL) {
		lprintf (KERN_INFO, "Shutting down controller 1...\n");
		(*capi_driver->detach_ctr) (capi_controller[1]);
	}
	lprintf (KERN_INFO, "Removing...\n");
	detach_capi_driver (&capi_interface);
	driver_exit ();
#ifndef NDEBUG
	if (hallocated() != 0) {
		lprintf (KERN_ERR, "%u bytes leaked.\n", hallocated());
	}
#endif
	lprintf (KERN_INFO, "Removed.\n");
} /* fcdsl_exit  */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
module_init (fcdsl_init);
module_exit (fcdsl_exit);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/

