/* 
 * tables.h
 * Copyright (C) 2002, AVM GmbH. All rights reserved.
 * 
 * This Software is  free software. You can redistribute and/or
 * modify such free software under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * The free software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this Software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA, or see
 * http://www.opensource.org/licenses/lgpl-license.html
 * 
 * Contact: AVM GmbH, Alt-Moabit 95, 10559 Berlin, Germany, email: info@avm.de
 */

#ifndef __have_tables_h__
#define __have_tables_h__

#include <asm/types.h>
#include <linux/skbuff.h>
#include <linux/capi.h>
#include "queue.h"
#include "capilli.h"

typedef struct __ncci {

	NCCI_t			ncci;
	unsigned		appl;
	unsigned		win_size;
	unsigned		blk_size;
	unsigned char **	data;
	struct __ncci *		pred;
	struct __ncci *		succ;
} ncci_t;

typedef struct __appl {

	unsigned		id;
	unsigned		dying;
	void *			data;
	unsigned		blk_size;
	unsigned		blk_count;
	unsigned		ncci_count;
	unsigned		nncci;
	ncci_t *		root;
	struct __appl *		pred;
	struct __appl *		succ;
} appl_t;

typedef struct __appltab {

	appl_t *		appl_root;
	unsigned		appl_count;
} appltab_t;

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern void table_init (appltab_t ** tab);
extern void table_exit (appltab_t ** tab);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern appl_t * create_appl (appltab_t * tab, 
			     unsigned    id, 
			     unsigned    ncount, 
			     unsigned    bcount, 
			     unsigned    bsize);
extern void remove_appl (appltab_t * tab, appl_t * appp);

extern appl_t * search_appl (appltab_t * tab, unsigned id);
extern appl_t * get_appl (appltab_t * tab, unsigned ix);
extern appl_t * first_appl (appltab_t * tab);
extern appl_t * next_appl (appltab_t * tab, appl_t * appp);

extern int handle_message (appltab_t * tab, appl_t * appp, struct sk_buff * msg);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern ncci_t * create_ncci (appltab_t * tab, 
			     appl_t *    appl, 
			     NCCI_t      ncci, 
			     unsigned    wsize, 
			     unsigned    bsize);
extern void remove_ncci (appltab_t * tab, appl_t * appp, ncci_t * nccip);

extern unsigned char * ncci_data_buffer (appltab_t * tab,
					 appl_t *    appl,
					 NCCI_t      ncci,
					 unsigned    index);

extern ncci_t * locate_ncci (appl_t * appp, NCCI_t ncci);

#endif
