/* 
 * tools.h
 * Copyright (C) 2002, AVM GmbH. All rights reserved.
 * 
 * This Software is  free software. You can redistribute and/or
 * modify such free software under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * The free software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this Software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA, or see
 * http://www.opensource.org/licenses/lgpl-license.html
 * 
 * Contact: AVM GmbH, Alt-Moabit 95, 10559 Berlin, Germany, email: info@avm.de
 */

#ifndef __have_tools_h__
#define __have_tools_h__

#include <asm/atomic.h>
#include <linux/types.h>
#include <stdarg.h>
#include "defs.h"

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
static __inline__ int atomic_inc_and_test (atomic_t * v) {
	unsigned char	c;

	__asm__ __volatile__(
		LOCK "incl %0; sete %1"
		: "=m" (v->counter), "=qm" (c)
		: "m"  (v->counter) : "memory"
	);
	return c != 0;
}
#endif

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,4)
#define	VSNPRINTF(s,n,f,a)	vsnprintf (s, n, f, a)
#define	SNPRINTF(s,n,f,l...)	snprintf (s, n, f, ##l)
#else
#define	VSNPRINTF(s,n,f,a)	vsprintf (s, f, a)
#define	SNPRINTF(s,n,f,l...)	sprintf (s, f, ##l)
#endif

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#ifndef NDEBUG
extern void message (const char * fmt, ...);
# define assert(x)	(!(x)?message("%s(%d): assert (%s) failed\n", \
                                        __FILE__, __LINE__, #x):((void)0))
# define info(x)	(!(x)?message("%s(%d): info (%s) failed\n", \
					__FILE__, __LINE__, #x):((void)0))
# define log(f,x...)	message (f, ##x)
#else
# define assert(x)
# define info(x)
# define log(f,x...)
#endif

#define error(f,x...)   lprintf (KERN_ERR, f, ##x)

extern void lprintf  (const char * level, const char * fmt, ...);
extern void vlprintf (const char * level, const char * fmt, va_list args);
extern unsigned long atomic_xchg (volatile atomic_t * v, unsigned value);

/*---------------------------------------------------------------------------*
\*---------------------------------------------------------------------------*/
typedef void (* nomem_handler_t) (unsigned size);

#ifndef NDEBUG
extern unsigned hallocated (void);
extern unsigned hallocator (void * mem);
extern int hvalid (void * mem);
#endif

/*---------------------------------------------------------------------------*
\*---------------------------------------------------------------------------*/
extern nomem_handler_t hset_handler (nomem_handler_t hndf);

/*---------------------------------------------------------------------------*
\*---------------------------------------------------------------------------*/
extern void * hmalloc (unsigned size);
extern void * hcalloc (unsigned size);
extern void * hmalloc_kernel (unsigned size);
extern void * hcalloc_kernel (unsigned size);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern void hfree (void * mem);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#if !defined (NDEBUG) && defined (LOG_TIMER)

#include <linux/time.h>

typedef struct {

	const char *	name;
	struct timeval	t;
	struct timeval	d;
} dbg_timer;

#define	PRINT_TIMER(x)		log ( \
					"Timer '%s': %ld s, %ld s\n", \
					(x)->name, \
					(x)->t.tv_sec, (x)->t.tv_usec \
				)
#define	PRINT_TIME_MSG(s,x)	log ( \
					"%s: %ld s, %ld s\n", \
					s, (x)->t.tv_sec, (x)->t.tv_usec \
				)

#define	WATCH_DECL(id)		dbg_timer	id##_timer
#define	WATCH_START(id)		start_watch (&id##_timer)
#define	WATCH_STOP(id)		stop_watch (&id##_timer); \
				PRINT_TIME_MSG(#id,&id##_timer)
	
/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern int	timers_start (void);
extern void	timers_stop (void);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern void	setup_timer (dbg_timer * t, long dsec, long dusec);
extern int	check_timer (dbg_timer * t);
extern int	check_timer_cb (dbg_timer * t, void (* callback) (dbg_timer *, struct timeval *));
extern void	touch_timer (dbg_timer * t);

extern void	start_watch (dbg_timer * w);
extern void	stop_watch (dbg_timer * w);
#else
#define	PRINT_TIMER(t)
#define	WATCH_DECL(name)
#define	WATCH_START(name)
#define	WATCH_STOP(name)
#endif

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
#include <linux/pci.h>

#ifndef PCI_ANY_ID
#define PCI_ANY_ID (~0)
#endif

struct pci_dev * pci_find_subsys (
	unsigned int            vendor,
	unsigned int            device,
	unsigned int            ss_vendor,
	unsigned int            ss_device,
	struct pci_dev *        from
);

#define	pci_resource_start_io(d, n)	(d->base_address[n] & PCI_BASE_ADDRESS_IO_MASK)
#define	pci_resource_start_mem(d, n)	(d->base_address[n] & PCI_BASE_ADDRESS_MEM_MASK)
#else
#define	pci_resource_start_io(d, n)	pci_resource_start (d, n)
#define	pci_resource_start_mem(d, n)	pci_resource_start (d, n)
#endif
										
/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#ifdef NEED_MEM_STR_PROTOS

extern void * memcpy (void * d, const void * s, size_t n);
extern void * memmove (void * d, const void * s, size_t n);
extern void * memset (void * m, int x, size_t c);

extern int memcmp (const void * s1, const void * s2, size_t n);

extern char * strcpy (char * d, const char * s);
extern char * strncpy (char * d, const char * s, unsigned n);
extern char * strcat (char * d, const char * s);
extern int strcmp (const char * s1, const char * s2);
extern int strncmp (const char * s1, const char * s2, unsigned n);

extern size_t strlen (const char * s);

#endif
#endif
